/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;

public final class RecipeBookStatus {
    private static final Map<RecipeBookCategory, Pair<String, String>> field_242147_a = ImmutableMap.of((Object)((Object)RecipeBookCategory.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookCategory.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookCategory.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookCategory.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookCategory, CategoryStatus> field_242148_b;

    private RecipeBookStatus(Map<RecipeBookCategory, CategoryStatus> map) {
        this.field_242148_b = map;
    }

    public RecipeBookStatus() {
        this(Util.func_200696_a(Maps.newEnumMap(RecipeBookCategory.class), enumMap -> {
            for (RecipeBookCategory recipeBookCategory : RecipeBookCategory.values()) {
                enumMap.put(recipeBookCategory, new CategoryStatus(false, false));
            }
        }));
    }

    public boolean func_242151_a(RecipeBookCategory recipeBookCategory) {
        return this.field_242148_b.get((Object)recipeBookCategory).field_242162_a;
    }

    public void func_242152_a(RecipeBookCategory recipeBookCategory, boolean bl) {
        this.field_242148_b.get((Object)recipeBookCategory).field_242162_a = bl;
    }

    public boolean func_242158_b(RecipeBookCategory recipeBookCategory) {
        return this.field_242148_b.get((Object)recipeBookCategory).field_242163_b;
    }

    public void func_242159_b(RecipeBookCategory recipeBookCategory, boolean bl) {
        this.field_242148_b.get((Object)recipeBookCategory).field_242163_b = bl;
    }

    public static RecipeBookStatus func_242157_a(PacketBuffer packetBuffer) {
        EnumMap enumMap = Maps.newEnumMap(RecipeBookCategory.class);
        for (RecipeBookCategory recipeBookCategory : RecipeBookCategory.values()) {
            boolean bl = packetBuffer.readBoolean();
            \u2603 = packetBuffer.readBoolean();
            enumMap.put(recipeBookCategory, new CategoryStatus(bl, \u2603));
        }
        return new RecipeBookStatus(enumMap);
    }

    public void func_242161_b(PacketBuffer packetBuffer) {
        for (RecipeBookCategory recipeBookCategory : RecipeBookCategory.values()) {
            CategoryStatus categoryStatus = this.field_242148_b.get((Object)recipeBookCategory);
            if (categoryStatus == null) {
                packetBuffer.writeBoolean(false);
                packetBuffer.writeBoolean(false);
                continue;
            }
            packetBuffer.writeBoolean(categoryStatus.field_242162_a);
            packetBuffer.writeBoolean(categoryStatus.field_242163_b);
        }
    }

    public static RecipeBookStatus func_242154_a(CompoundNBT compoundNBT) {
        EnumMap enumMap = Maps.newEnumMap(RecipeBookCategory.class);
        field_242147_a.forEach((recipeBookCategory, pair) -> {
            boolean bl = compoundNBT.func_74767_n((String)pair.getFirst());
            \u2603 = compoundNBT.func_74767_n((String)pair.getSecond());
            enumMap.put(recipeBookCategory, new CategoryStatus(bl, \u2603));
        });
        return new RecipeBookStatus(enumMap);
    }

    public void func_242160_b(CompoundNBT compoundNBT) {
        field_242147_a.forEach((recipeBookCategory, pair) -> {
            CategoryStatus categoryStatus = this.field_242148_b.get(recipeBookCategory);
            compoundNBT.func_74757_a((String)pair.getFirst(), categoryStatus.field_242162_a);
            compoundNBT.func_74757_a((String)pair.getSecond(), categoryStatus.field_242163_b);
        });
    }

    public RecipeBookStatus func_242149_a() {
        EnumMap enumMap = Maps.newEnumMap(RecipeBookCategory.class);
        for (RecipeBookCategory recipeBookCategory : RecipeBookCategory.values()) {
            CategoryStatus categoryStatus = this.field_242148_b.get((Object)recipeBookCategory);
            enumMap.put(recipeBookCategory, categoryStatus.func_242164_a());
        }
        return new RecipeBookStatus(enumMap);
    }

    public void func_242150_a(RecipeBookStatus recipeBookStatus) {
        this.field_242148_b.clear();
        for (RecipeBookCategory recipeBookCategory : RecipeBookCategory.values()) {
            CategoryStatus categoryStatus = recipeBookStatus.field_242148_b.get((Object)recipeBookCategory);
            this.field_242148_b.put(recipeBookCategory, categoryStatus.func_242164_a());
        }
    }

    public boolean equals(Object object) {
        return this == object || object instanceof RecipeBookStatus && this.field_242148_b.equals(((RecipeBookStatus)object).field_242148_b);
    }

    public int hashCode() {
        return this.field_242148_b.hashCode();
    }

    static final class CategoryStatus {
        private boolean field_242162_a;
        private boolean field_242163_b;

        public CategoryStatus(boolean bl, boolean bl2) {
            this.field_242162_a = bl;
            this.field_242163_b = bl2;
        }

        public CategoryStatus func_242164_a() {
            return new CategoryStatus(this.field_242162_a, this.field_242163_b);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CategoryStatus) {
                CategoryStatus categoryStatus = (CategoryStatus)object;
                return this.field_242162_a == categoryStatus.field_242162_a && this.field_242163_b == categoryStatus.field_242163_b;
            }
            return false;
        }

        public int hashCode() {
            int n = this.field_242162_a ? 1 : 0;
            n = 31 * n + (this.field_242163_b ? 1 : 0);
            return n;
        }

        public String toString() {
            return "[open=" + this.field_242162_a + ", filtering=" + this.field_242163_b + ']';
        }
    }
}

